<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
$uploadDir = 'uploads/';
$segmentDir = $uploadDir . 'segments_' . date('Ymd_His') . '/';
$maxSize = 20 * 1024 * 1024; // 20MB

// ✅ FFmpeg path for Windows
$ffmpegPath = 'C:\\ffmpeg\\bin\\ffmpeg.exe';

// ✅ Create directories if not exist
if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);
if (!is_dir($segmentDir)) mkdir($segmentDir, 0755, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_FILES['video']) || $_FILES['video']['error'] !== UPLOAD_ERR_OK) {
        echo json_encode([
            'status' => 'error',
            'message' => 'No video file uploaded or file error.'
        ]);
        exit;
    }

    $file = $_FILES['video'];

    // ✅ Validate file type
    $allowedTypes = ['video/mp4', 'video/avi', 'video/mov'];
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime = finfo_file($finfo, $file['tmp_name']);
    finfo_close($finfo);

    if (!in_array($mime, $allowedTypes)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Unsupported video format.'
        ]);
        exit;
    }

    $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
    $uniqueName = uniqid('video_', true) . '.' . $ext;
    $targetFilePath = $uploadDir . $uniqueName;

    // ✅ Compress if needed
    if ($file['size'] > $maxSize) {
        $compressedFilePath = $uploadDir . 'compressed_' . $uniqueName;
        $input = '"' . realpath($file['tmp_name']) . '"';
        $output = '"' . realpath($compressedFilePath) . '"';
        $command = "\"$ffmpegPath\" -i $input -vcodec libx264 -crf 28 $output 2>&1";

        exec($command, $outputLog, $returnVar);
        if ($returnVar !== 0) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Video compression failed.',
                'error_output' => $outputLog
            ]);
            exit;
        }

        $targetFilePath = $compressedFilePath;
    } else {
        if (!move_uploaded_file($file['tmp_name'], $targetFilePath)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to move uploaded video.'
            ]);
            exit;
        }
    }

    // ✅ Clean segment folder (optional)
    array_map('unlink', glob($segmentDir . '*.mp4'));

    // ✅ Segment the video
    $segmentDuration = 10;
    $escapedInput = '"' . realpath($targetFilePath) . '"';
    $escapedPattern = '"' . realpath($segmentDir) . DIRECTORY_SEPARATOR . 'segment_%03d.mp4' . '"';

    $segmentCmd = "\"$ffmpegPath\" -i $escapedInput -c copy -map 0 -f segment -segment_time $segmentDuration $escapedPattern 2>&1";
    exec($segmentCmd, $segmentLog, $segmentResult);

    if ($segmentResult === 0) {
        $segments = array_map('basename', glob($segmentDir . '*.mp4'));

        // Insert the uploaded video URL into the database
        $mysqli = new mysqli('localhost', 'root', '', 'your_database_name');
        if ($mysqli->connect_errno) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Database connection failed: ' . $mysqli->connect_error
            ]);
            exit;
        }

        $feed_url_id = uniqid('feedurl_', true);
        $feed_id = ''; // Set this as needed
        $url_type = 'video';
        $urls = $targetFilePath;
        $status = 1;
        $created_at = date('Y-m-d H:i:s');

        $stmt = $mysqli->prepare("INSERT INTO `feed_url` (`feed_url_id`, `feed_id`, `url_type`, `urls`, `status`, `created_at`) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('ssssis', $feed_url_id, $feed_id, $url_type, $urls, $status, $created_at);

        if ($stmt->execute()) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Video uploaded, segmented, and URL inserted successfully.',
                'segments' => $segments,
                'feed_url_id' => $feed_url_id
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to insert video URL into database.',
                'db_error' => $stmt->error
            ]);
        }

        $stmt->close();
        $mysqli->close();
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to segment the video.',
            'error_output' => $segmentLog
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request.'
    ]);
}
?>
