<?php

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => false, "message" => "Only POST requests are allowed."]);
    exit;
}

require_once 'db.php';
require_once 'function.php';

// Get POST data
$user_id = $_POST['user_id'] ?? null;
$profile_visibility = $_POST['profile_visibility'] ?? null;
$comment_show = $_POST['comment_show'] ?? null;
$who_follow_you = $_POST['who_follow_you'] ?? null;

if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "Missing user_id"]);
    exit;
}

// Prepare the query
$fields = [];
$params = [];
$types = "";

// Add optional fields
if (!is_null($profile_visibility)) {
    $fields[] = "profile_visibility = ?";
    $params[] = $profile_visibility;
    $types .= "s";
}
if (!is_null($comment_show)) {
    $fields[] = "comment_show = ?";
    $params[] = $comment_show;
    $types .= "s";
}
if (!is_null($who_follow_you)) {
    $fields[] = "who_follow_you = ?";
    $params[] = $who_follow_you;
    $types .= "s";
}

// Always update updated_at
$fields[] = "updated_at = NOW()";

if (empty($fields)) {
    echo json_encode(["status" => "error", "message" => "No fields to update"]);
    exit;
}
$sql = "UPDATE user_account_setting SET " . implode(", ", $fields) . " WHERE user_id = ?";
$params[] = $user_id;

$stmt = $pdo->prepare($sql);

if ($stmt->execute($params)) {
    echo json_encode(["status" => "success", "message" => "Settings updated"]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Update failed",
        "error" => $stmt->errorInfo()
    ]);
}


?>
