<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST is allowed."]);
    exit;
}

require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Validate required fields
if (
    empty($_POST['feed_id']) ||
    empty($_POST['user_id']) ||
    empty($_POST['contents']) ||
    empty($_POST['status'])
) {
    echo json_encode(["error" => "All fields are required."]);
    exit;
}

// Prepare comment data
$comment_id = generateCommentId($pdo); // Autogenerate comment_id
$feed_id = htmlspecialchars($_POST['feed_id']);
$user_id = htmlspecialchars($_POST['user_id']);
$contents = htmlspecialchars($_POST['contents']);
$status = htmlspecialchars($_POST['status']);
$created_at = date('Y-m-d H:i:s');

$sql = "INSERT INTO feed_comments (comment_id, feed_id, user_id, contents, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?)";
$stmt = $pdo->prepare($sql);

try {
    if ($stmt->execute([$comment_id, $feed_id, $user_id, $contents, $status, $created_at])) {
        if ($stmt->rowCount() > 0) {
            echo json_encode([
                "success" => true,
                "message" => "Comment added successfully.",
                "comment_id" => $comment_id
            ]);
        } else {
            echo json_encode(["error" => "Failed to add comment."]);
        }
    } else {
        echo json_encode(["error" => "Something went wrong while adding the comment."]);
    }
} catch (PDOException $e) {
    echo json_encode(["error" => "Failed to add comment."]);
}
?>