<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST is allowed."]);
    exit;
}

require_once 'db.php';       // DB connection ($pdo)

$action = $_POST['action'] ?? '';
$follower_id = $_POST['follower_id'] ?? '';
$following_id = $_POST['following_id'] ?? '';
$ff_id = uniqid('ff_', true); // Unique follow ID

// Input checks
if (!$follower_id || !$following_id || $follower_id === $following_id || !in_array($action, ['follow', 'unfollow'])) {
    echo json_encode(['error' => 'Invalid input']);
    exit;
}

try {
    if ($action === 'follow') {
        $sql = "INSERT IGNORE INTO user_follows (ff_id, follower_id, following_id) VALUES (?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$ff_id, $follower_id, $following_id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => 'success', 'message' => 'Followed successfully']);
        } else {
            echo json_encode(['success' => 'error', 'message' => 'Already followed']);
        }

    } elseif ($action === 'unfollow') {
        $sql = "DELETE FROM user_follows WHERE follower_id = ? AND following_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$follower_id, $following_id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => 'success', 'message' => 'Unfollowed successfully']);
        } else {
            echo json_encode(['success' => 'error', 'message' => 'Not following']);
        }
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Something went wrong', 'details' => $e->getMessage()]);
}
?>
