<?php
// Enable CORS if calling from Flutter/web
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Path to ffmpeg on Windows (make sure this is correct)
$ffmpegPath = 'C:\\ffmpeg\\bin\\ffmpeg.exe'; // Or wherever you installed FFmpeg

// Check if video file is received
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['video'])) {
    $video = $_FILES['video'];

    // Validate file type
    if ($video['type'] !== 'video/mp4') {
        http_response_code(400);
        echo json_encode(['error' => 'Only MP4 videos are allowed.']);
        exit;
    }

    // Directories
    $uploadDir = __DIR__ . '/uploads/';
    $hlsDir = __DIR__ . '/segments/';
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);
    if (!is_dir($hlsDir)) mkdir($hlsDir, 0755, true);

    // File names
    $baseName = pathinfo($video['name'], PATHINFO_FILENAME);
    $mp4Path = $uploadDir . $video['name'];
    $playlistFile = $hlsDir . $baseName . '.m3u8';
    $segmentPattern = $hlsDir . $baseName . '_%03d.ts';

    // Save uploaded MP4
    if (!move_uploaded_file($video['tmp_name'], $mp4Path)) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to move uploaded file.']);
        exit;
    }

    // Normalize Windows paths for shell execution
    $mp4Path = str_replace("\\", "/", $mp4Path);
    $playlistFile = str_replace("\\", "/", $playlistFile);
    $segmentPattern = str_replace("\\", "/", $segmentPattern);
    $ffmpegPath = str_replace("\\", "/", $ffmpegPath);

    // Build FFmpeg command
    $ffmpegCmd = "\"$ffmpegPath\" -i \"$mp4Path\" -preset veryfast -g 48 -sc_threshold 0 " .
                 "-map 0:v -map 0:a -f hls -hls_time 4 -hls_playlist_type vod " .
                 "-hls_segment_filename \"$segmentPattern\" \"$playlistFile\"";

    // Execute FFmpeg
    exec($ffmpegCmd . " 2>&1", $output, $returnCode);

    if ($returnCode !== 0) {
        http_response_code(500);
        echo json_encode([
            'error' => 'FFmpeg failed to convert the video.',
            'details' => $output
        ]);
        exit;
    }

    // Return HLS playlist URL
    $baseUrl = 'https://yourdomain.com/segments/'; // Change this to your actual domain path
    $publicUrl = $baseUrl . basename($playlistFile);

    echo json_encode([
        'message' => 'Video converted successfully.',
        'hls_url' => $publicUrl
    ]);
} else {
    http_response_code(400);
    echo json_encode(['error' => 'No video uploaded.']);
}
?>
