<?php
// Enable CORS if calling from Flutter/web
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once 'db.php'; // Include your DB connection

// Path to ffmpeg on Windows (adjust path as needed)
$ffmpegPath = 'C:\\ffmpeg\\bin\\ffmpeg.exe';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['video'])) {
    $video = $_FILES['video'];

    // Metadata from POST
    $userId         = $_POST['user_id'] ?? 'default_user';
    $caption        = $_POST['caption'] ?? 'No caption';
    $privacy        = $_POST['privacy'] ?? 'public';
    $commentAllow   = $_POST['comment_allow'] ?? 'public';
    $educationType  = $_POST['education_type'] ?? 'all';
    $deviceName     = $_POST['device_name'] ?? 'unknown';

    // Directories
    $uploadDir   = __DIR__ . '/uploads/';
    $hlsDir      = __DIR__ . '/segments/';
    $thumbDir    = __DIR__ . '/thumbnails/';

    if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);
    if (!is_dir($hlsDir)) mkdir($hlsDir, 0755, true);
    if (!is_dir($thumbDir)) mkdir($thumbDir, 0755, true);

    // Build file names
    $originalName = pathinfo($video['name'], PATHINFO_FILENAME);
    $extension    = pathinfo($video['name'], PATHINFO_EXTENSION);
    $timestamp    = date('Ymd_His');
    $baseName     = $originalName . '_' . $timestamp;

    // File paths
    $mp4Path        = $uploadDir . $baseName . '.' . $extension;
    $playlistFile   = $hlsDir . $baseName . '.m3u8';
    $segmentPattern = $hlsDir . $baseName . '_%03d.ts';
    $thumbPath      = $thumbDir . $baseName . '.jpg';

    // Normalize paths for Windows
    $ffmpegPath      = str_replace("\\", "/", $ffmpegPath);
    $mp4Path         = str_replace("\\", "/", $mp4Path);
    $playlistFile    = str_replace("\\", "/", $playlistFile);
    $segmentPattern  = str_replace("\\", "/", $segmentPattern);
    $thumbPath       = str_replace("\\", "/", $thumbPath);

    // Move uploaded file
    if (!move_uploaded_file($video['tmp_name'], $mp4Path)) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to move uploaded file.']);
        exit;
    }

    // FFmpeg command for HLS
    $ffmpegCmd = "\"$ffmpegPath\" -i \"$mp4Path\" -preset veryfast -g 48 -sc_threshold 0 " .
                 "-map 0:v -map 0:a -f hls -hls_time 4 -hls_playlist_type vod " .
                 "-hls_segment_filename \"$segmentPattern\" \"$playlistFile\"";

    exec($ffmpegCmd . " 2>&1", $output, $returnCode);

    if ($returnCode !== 0) {
        http_response_code(500);
        echo json_encode([
            'error' => 'FFmpeg failed to convert the video.',
            'details' => $output
        ]);
        exit;
    }

    // FFmpeg command for thumbnail (capture frame at 1s)
    $ffmpegThumbCmd = "\"$ffmpegPath\" -i \"$mp4Path\" -ss 00:00:01.000 -vframes 1 \"$thumbPath\"";
    exec($ffmpegThumbCmd . " 2>&1", $thumbOutput, $thumbReturnCode);

    if ($thumbReturnCode !== 0) {
        http_response_code(500);
        echo json_encode([
            'error' => 'Thumbnail generation failed.',
            'details' => $thumbOutput
        ]);
        exit;
    }

    // Generate database values
    $reelsId   = uniqid('reel_');
    $status    = 'published';
    $message   = 'published';
    $createdAt = date('Y-m-d H:i:s');
    $updatedAt = $createdAt;

    // Public URLs
    $publicVideoUrl = 'segments/' . basename($playlistFile);
    $publicThumbUrl = 'thumbnails/' . basename($thumbPath);

    // Insert into DB
    $stmt = $pdo->prepare("INSERT INTO `reels` 
        (`reels_id`, `user_id`, `captioon`, `education_type`, `comment_allow`, `video_privacy`, `file_url`, `reels_thum`, `message`, `status`, `created_at`, `updated_at`)
        VALUES 
        (:reels_id, :user_id, :caption, :education_type, :comment_allow, :privacy, :file_url, :reels_thum, :message, :status, :created_at, :updated_at)");

    $stmt->bindValue(':reels_id', $reelsId);
    $stmt->bindValue(':user_id', $userId);
    $stmt->bindValue(':caption', $caption);
    $stmt->bindValue(':education_type', $educationType);
    $stmt->bindValue(':comment_allow', $commentAllow);
    $stmt->bindValue(':privacy', $privacy);
    $stmt->bindValue(':file_url', $publicVideoUrl);
    $stmt->bindValue(':reels_thum', $publicThumbUrl);
    $stmt->bindValue(':message', $message);
    $stmt->bindValue(':status', $status);
    $stmt->bindValue(':created_at', $createdAt);
    $stmt->bindValue(':updated_at', $updatedAt);

    if (!$stmt->execute()) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to insert into database']);
        exit;
    }

    // Final response
    echo json_encode([
        'message' => 'Video uploaded, converted, and thumbnail created successfully.',
        'reels_id' => $reelsId,
        'hls_url' => $publicVideoUrl,
        'reels_thum' => $publicThumbUrl,
        'video_file' => basename($mp4Path),
        'metadata' => [
            'user_id' => $userId,
            'caption' => $caption,
            'privacy' => $privacy,
            'comment_allow' => $commentAllow,
            'education_type' => $educationType,
            'device_name' => $deviceName,
            'created_at' => $createdAt
        ]
    ]);

} else {
    http_response_code(400);
    echo json_encode(['error' => 'No video uploaded.']);
}
?>
