<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");

require_once 'db.php'; // assumes $pdo is defined here

 {
    $cat_id = uniqid('CCI_');
    try {
        $sql = "INSERT INTO course_category 
                (c_category_id, title, status, created_at, updated_at, home_title) 
                VALUES (:c_category_id, :title, :status, :created_at, :updated_at, :home_title)";
        
        $stmt = $pdo->prepare($sql);
        $created_at = date('Y-m-d H:i:s');
        $update_at = date('Y-m-d H:i:s');
        $stmt->execute([
            ':c_category_id' => $cat_id,
            ':title' => $_POST['title'],
            ':status' => $_POST['status'],
            ':created_at' => $created_at,
            ':updated_at' => $update_at,
            ':home_title' => $_POST['home_title']
        ]);

        echo json_encode([
            "message" => "Course category inserted successfully.",
            "id" => $pdo->lastInsertId()
        ]);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["error" => "Database error: " . $e->getMessage()]);
    }
}
?>
