<?php 
function generateUserId($pdo) {
    $stmt = $pdo->query("SELECT user_id FROM users ORDER BY id DESC LIMIT 1");
    $lastUser = $stmt->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastUser['user_id']) ? ((int)substr($lastUser['user_id'], 3)) + 1 : 1;
    return 'USR' . str_pad($newId, 3, '0', STR_PAD_LEFT);
}

function generateKycId($pdo) {
    $query = "SELECT kyc_id FROM user_kyc ORDER BY id DESC LIMIT 1";
    $result = $pdo->query($query);
    $lastKyc = $result->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastKyc['kyc_id']) ? ((int)substr($lastKyc['kyc_id'], 3)) + 1 : 1;
    return 'KYC' . str_pad($newId, 3, '0', STR_PAD_LEFT);
}
function generateDociId($pdo) {
    $query = "SELECT user_doc_id FROM user_docupment ORDER BY id DESC LIMIT 1";
    $result = $pdo->query($query);
    $lastDoci = $result->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastDoci['user_doc_id']) ? ((int)substr($lastDoci['user_doc_id'], 4)) + 1 : 1;
    return 'DOCI' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}
function generateusaiId($pdo) {
    $query = "SELECT uas_id FROM user_account_setting ORDER BY id DESC LIMIT 1";
    $result = $pdo->query($query);
    $lastDoci = $result->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastDoci['uas_id']) ? ((int)substr($lastDoci['uas_id'], 4)) + 1 : 1;
    return 'USAC' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}


function generateCommentId($pdo) {
    $query = "SELECT comment_id FROM feed_comments ORDER BY id DESC LIMIT 1";
    $result = $pdo->query($query);
    $lastComment = $result->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastComment['comment_id']) ? ((int)substr($lastComment['comment_id'], 7)) + 1 : 1;
    return 'COMMENT' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}

function generateFeedId($pdo) {
    $stmt = $pdo->query("SELECT feed_id FROM feeds ORDER BY id DESC LIMIT 1");
    $lastFeed = $stmt->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastFeed['feed_id']) ? ((int)substr($lastFeed['feed_id'], 4)) + 1 : 1;
    return 'FID' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}
function generateFeedUrlId($pdo) {
    $query = "SELECT feed_url_id FROM feed_url ORDER BY id DESC LIMIT 1";
    $result = $pdo->query($query);
    $lastFeedUrl = $result->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastFeedUrl['feed_url_id']) ? ((int)substr($lastFeedUrl['feed_url_id'], 3)) + 1 : 1;
    return 'URL' . str_pad($newId, 3, '0', STR_PAD_LEFT);
}

function generateLocationId($pdo) {
    $query = "SELECT location_id FROM feed_location ORDER BY id DESC LIMIT 1";
    $result = $pdo->query($query);
    $lastLocation = $result->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastLocation['location_id']) ? ((int)substr($lastLocation['location_id'], 3)) + 1 : 1;
    return 'LOC' . str_pad($newId, 3, '0', STR_PAD_LEFT);
}
function generateUserTokenId($pdo) {
    $stmt = $pdo->query("SELECT user_token_id FROM user_token ORDER BY id DESC LIMIT 1");
    $lastToken = $stmt->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastToken['user_token_id']) ? ((int)substr($lastToken['user_token_id'], 3)) + 1 : 1;
    return 'UTK' . str_pad($newId, 3, '0', STR_PAD_LEFT);
}

// Course ID generation function
function generateCourseId($pdo) {
    $stmt = $pdo->query("SELECT course_id FROM courses ORDER BY id DESC LIMIT 1");
    $lastCourse = $stmt->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastCourse['course_id']) ? ((int)substr($lastCourse['course_id'], 4)) + 1 : 1;
    return 'CID' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}
function generateLessionId($pdo) {
    $stmt = $pdo->query("SELECT lession_id FROM lessions ORDER BY id DESC LIMIT 1");
    $lastLession = $stmt->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastLession['lession_id']) ? ((int)substr($lastLession['lession_id'], 4)) + 1 : 1;
    return 'LID' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}
function generateSemId($pdo) {
    $stmt = $pdo->query("SELECT sem_id FROM semesters ORDER BY id DESC LIMIT 1");
    $lastSem = $stmt->fetch(PDO::FETCH_ASSOC);
    $newId = isset($lastSem['sem_id']) ? ((int)substr($lastSem['sem_id'], 3)) + 1 : 1;
    return 'SID' . str_pad($newId, 4, '0', STR_PAD_LEFT);
}

function generateToken() {
    return bin2hex(random_bytes(32)); // 64-character token
}

function getUserIdByToken($pdo, $token) {
    try {
        $sql = "SELECT user_id FROM `user_token` WHERE `token` = :token LIMIT 1";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':token', $token, PDO::PARAM_STR);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            return $result['user_id'];
        } else {
            return 'null'; // Token not found
        }
    } catch (Exception $e) {
        throw new Exception("Error fetching user_id by token: " . $e->getMessage());
    }
}

?>