<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require_once 'db.php'; 
require_once 'castHelper.php'; 

try {
    // Ensure UTF-8
    $pdo->exec("SET NAMES utf8mb4");

    

    $stmt = $pdo->prepare("SELECT * FROM `faculty`");
    $stmt->execute();
    $faculty = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Apply type casting
    $faculty = array_map('castTypes', $faculty);

    echo json_encode([
        "status" => 'success',
        "data" => $faculty
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "status" => 'error',
        "error" => 'Database error occurred'
    ]);
    // Optionally log $e->getMessage()
}
?>
