<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Origin: *");// Change this to your domain
require_once 'db.php'; // Make sure $pdo is defined in this file

try {
    // Only allow GET requests
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
        exit;
    }

    // Optional: user ID for like check
    $user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;

    // Pagination setup
    $page = isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0 ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) && $_GET['limit'] > 0 ? (int)$_GET['limit'] : 5;
    $offset = ($page - 1) * $limit;

    // Get total feeds count
    $count_sql = "SELECT COUNT(*) as total FROM feeds";
    $count_stmt = $pdo->query($count_sql);
    $total = $count_stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Main feed query with pagination
   $sql = "SELECT f.*, fl.*, u.name, u.userName, u.profile_url
        FROM feeds f
        LEFT JOIN feed_location fl ON fl.feed_id = f.feed_id
        LEFT JOIN users u ON u.user_id = f.user_id
        ORDER BY f.id DESC
        LIMIT :limit OFFSET :offset";

    
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $data = [];

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $feed_id = $row['feed_id'];

            // Get media
            $media_stmt = $pdo->prepare("SELECT * FROM feed_url WHERE feed_id = :feed_id");
            $media_stmt->execute(['feed_id' => $feed_id]);
            $row['media'] = $media_stmt->fetchAll(PDO::FETCH_ASSOC);

            // Get comments
            $comments_stmt = $pdo->prepare("SELECT * FROM feed_comments WHERE feed_id = :feed_id");
            $comments_stmt->execute(['feed_id' => $feed_id]);
            $comments = $comments_stmt->fetchAll(PDO::FETCH_ASSOC);
            $row['comments'] = $comments;
            $row['total_comments'] = count($comments);

            // Get total likes
            $likes_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :feed_id");
            $likes_stmt->execute(['feed_id' => $feed_id]);
            $row['total_likes'] = (int)$likes_stmt->fetchColumn();

            // Check if user liked this post
            if ($user_id > 0) {
                $like_check_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :feed_id AND user_id = :user_id");
                $like_check_stmt->execute(['feed_id' => $feed_id, 'user_id' => $user_id]);
                $row['is_liked'] = $like_check_stmt->fetchColumn() > 0;
            } else {
                $row['is_liked'] = false;
            }
$row = array_map('castTypes', $row);
            $data[] = $row;
        }

        // Success response
        echo json_encode([
            "status" => "success",
            "data" => $data,
            "pagination" => [
                "page" => $page,
                "limit" => $limit,
                "totalData" => (int)$total,
                "pages" => ceil($total / $limit)
            ]
        ]);
    } else {
        echo json_encode(["status" => "error", "data" => [], "message" => "No records found"]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "An error occurred",
        "error" => $e->getMessage()
    ]);
}
?>
