<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php';
require_once 'castHelper.php'; 
try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
        exit;
    }

    $category_id = isset($_GET['category_id']) ? trim($_GET['category_id']) : null;
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : null;

    $sql = "SELECT * FROM `quizs`";
    $params = [];

    // Apply WHERE condition
    if (!empty($category_id)) {
        $sql .= " WHERE `category_id` = :category_id";
        $params['category_id'] = $category_id;
    }

    // Apply LIMIT
    if (!empty($limit) && $limit > 0) {
        $sql .= " LIMIT :limit";
    }

    $stmt = $pdo->prepare($sql);

    // Bind params
    if (!empty($category_id)) {
        $stmt->bindParam(':category_id', $params['category_id'], PDO::PARAM_STR);
    }

    if (!empty($limit) && $limit > 0) {
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    }

    $stmt->execute();

    $quizs = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $quiz_id = $row['quiz_id'];
        $options_sql = "SELECT * FROM `options` WHERE `quiz_id` = :quiz_id";
        $options_stmt = $pdo->prepare($options_sql);
        $options_stmt->execute(['quiz_id' => $quiz_id]);
        $options = $options_stmt->fetchAll(PDO::FETCH_ASSOC);

        $row['options'] = $options;
          $row = array_map('castTypes', $row);
        $quizs[] = $row;
    }

    echo json_encode(["status" => "success", "data" => $quizs]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "An error occurred", "error" => $e->getMessage()]);
}
?>
