<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php';
require_once 'castHelper.php'; 
// Get pagination parameters
$page  = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? (int) $_GET['limit'] : 10;
$offset = ($page - 1) * $limit;

try {
    // Step 1: Get total count of categories
    $countQuery = "SELECT COUNT(*) AS total FROM quiz_category";
    $countStmt = $pdo->prepare($countQuery);
    $countStmt->execute();
    $total = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Step 2: Fetch paginated categories
    $categoryQuery = "SELECT * FROM quiz_category ORDER BY update_at DESC LIMIT :limit OFFSET :offset";
    $categoryStmt = $pdo->prepare($categoryQuery);
    $categoryStmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $categoryStmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $categoryStmt->execute();
    $categories = $categoryStmt->fetchAll(PDO::FETCH_ASSOC);

    $finalResult = [];

    // Step 3: For each category, fetch related games
    foreach ($categories as $category) {
        $category_id = $category['category_id'];

        $gameQuery = "SELECT * FROM quiz_games_cate WHERE category_id = :category_id";
        $gameStmt = $pdo->prepare($gameQuery);
        $gameStmt->bindParam(':category_id', $category_id);
        $gameStmt->execute();
        $games = $gameStmt->fetchAll(PDO::FETCH_ASSOC);

        $category['games'] = $games;
          $category = array_map('castTypes', $category);
        $finalResult[] = $category;
    }

    // Step 4: Return paginated data
    echo json_encode([
        "status" => "success",
        "page" => $page,
        "limit" => $limit,
        "total" => (int)$total,
        "pages" => ceil($total / $limit),
        "data" => $finalResult
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
