<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require_once 'db.php';
require_once 'castHelper.php'; 
// Validate faculty_id
if (!isset($_GET['faculty_id']) || empty($_GET['faculty_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'error' => 'required faculty_id']);
    exit;
}

$faculty_id = $_GET['faculty_id'];
$type = isset($_GET['types']) ? $_GET['types'] : 'default';

try {
    if ($type === 'semester') {
        // Only fetch semesters
        $stmt = $pdo->prepare("SELECT * FROM semesters WHERE faculty_id = ?");
        $stmt->execute([$faculty_id]);
        $semesters = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($semesters) {
            echo json_encode([
                'status' => 'success',
                'type' => 'semesters',
                'data' => $semesters
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'No semesters found'
            ]);
        }

    } elseif ($type === 'course') {
        // Only fetch courses
        $stmt = $pdo->prepare("
        SELECT 
        courses.*,
        IFNULL(subject_category.title, 'None') AS subject_title,
        IFNULL(subject_category.status, 'None') AS subject_status,
        COUNT(DISTINCT feed_comments.comment_id) AS total_comments,
        COUNT(DISTINCT likes.like_id) AS total_likes
    FROM courses
    LEFT JOIN subject_category ON courses.subject_cid = subject_category.sc_id
    LEFT JOIN feed_comments ON feed_comments.feed_id = courses.course_id
    LEFT JOIN likes ON likes.post_id = courses.course_id
    WHERE courses.semester_id = ?
    GROUP BY courses.course_id");
        $stmt->execute([$faculty_id]);
        $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($courses) {
            echo json_encode([
                'status' => 'success',
                'type' => 'courses',
                'data' => $courses
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'No courses found'
            ]);
        }

    } else {
        // Default behavior: try semesters first, fallback to courses
        $stmt = $pdo->prepare("SELECT * FROM semesters WHERE faculty_id = ?");
        $stmt->execute([$faculty_id]);
        $semesters = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($semesters) {
            echo json_encode([
                'status' => 'success',
                'type' => 'semesters',
                'data' => $semesters
            ]);
        } else {
            $stmt2 = $pdo->prepare("SELECT * FROM courses WHERE fac_id = ?");
            $stmt2->execute([$faculty_id]);
            $courses = $stmt2->fetchAll(PDO::FETCH_ASSOC);
  $courses = array_map('castTypes', $courses);
            if ($courses) {
                echo json_encode([
                    'status' => 'success',
                    'type' => 'courses',
                    'data' => $courses
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'No semesters or courses found'
                ]);
            }
        }
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}
?>