<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Origin: *"); // For dev only
 // Change this to your domain
require_once 'db.php'; // Make sure $pdo is defined in this file
require_once 'castHelper.php'; 
try {
    // Only allow GET requests
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
        exit;
    }

    $user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
    $feed_id = isset($_GET['feed_id']) ? $_GET['feed_id'] : null;

    if ($feed_id) {
        // Fetch a single feed
        $sql = "SELECT f.*, fl.*, u.name, u.userName, u.profile_url
                FROM feeds f
                LEFT JOIN feed_location fl ON fl.feed_id = f.feed_id
                LEFT JOIN users u ON u.user_id = f.user_id
                WHERE f.feed_id = :feed_id
                LIMIT 1";

        $stmt = $pdo->prepare($sql);
        $stmt->execute(['feed_id' => $feed_id]);

        if ($stmt->rowCount() === 1) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            // Get media
            $media_stmt = $pdo->prepare("SELECT * FROM feed_url WHERE feed_id = :feed_id");
            $media_stmt->execute(['feed_id' => $feed_id]);
            $row['media'] = $media_stmt->fetchAll(PDO::FETCH_ASSOC);

           // Get comments with user details
           // Get comments with user details (even if user is missing)
            $comments_stmt = $pdo->prepare("
                SELECT 
                    fc.comment_id, 
                    fc.feed_id, 
                    fc.contents, 
                    fc.status, 
                    fc.created_at, 
                    u.user_id, 
                    u.name, 
                    u.userName, 
                    u.profile_url
                FROM feed_comments fc
                LEFT JOIN users u ON fc.user_id = u.user_id
                WHERE fc.feed_id = :feed_id
            ");
            $comments_stmt->execute(['feed_id' => $feed_id]);
            $comments = $comments_stmt->fetchAll(PDO::FETCH_ASSOC);
            // Add to feed row
            $row['comments'] = $comments;
            $row['total_comments'] = count($comments);
            // Get total likes
            $likes_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :feed_id");
            $likes_stmt->execute(['feed_id' => $feed_id]);
            $row['total_likes'] = (int)$likes_stmt->fetchColumn();

            // Check if user liked this post
            if ($user_id > 0) {
                $like_check_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :feed_id AND user_id = :user_id");
                $like_check_stmt->execute(['feed_id' => $feed_id, 'user_id' => $user_id]);
                $row['is_liked'] = $like_check_stmt->fetchColumn() > 0;
            } else {
                $row['is_liked'] = false;
            }
  $row = array_map('castTypes', $row);
            echo json_encode([
                "status" => "success",
                "data" => $row
            ]);
        } else {
            echo json_encode(["status" => "error", "message" => "Feed not found"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "feed_id is required"]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "An error occurred",
        "error" => $e->getMessage()
    ]);
}
