<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate required fields
    if (
        !empty($_POST['user_id']) && 
        !empty($_POST['name']) && 
        !empty($_POST['dob']) && 
        !empty($_POST['gender']) && 
        !empty($_POST['occupation_type']) && 
        !empty($_POST['occupation_content']) && 
        !empty($_POST['address']) && 
        !empty($_POST['status']) 
    ) {
        $user_id = $_POST['user_id'];
        $kyc_id = generateKycId($pdo); // Autogenerate KYC ID
        $name = $_POST['name'];
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $occupation_type = $_POST['occupation_type'];
        $occupation_content = $_POST['occupation_content'];
        $address = $_POST['address'];
        $status = $_POST['status'];
        $created_at = date('Y-m-d H:i:s');
        $updated_at = date('Y-m-d H:i:s');

        // Prepare the SQL query
        $sql = "INSERT INTO `user_kyc`(`user_id`, `kyc_id`, `name`, `dob`, `gender`, `oppucation_type`, `oppucation_content`, `address`, `status`, `created_at`, `updated_at`) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        // Prepare the statement
        $stmt = $pdo->prepare($sql);
        $params = [
            $user_id,
            $kyc_id,
            $name,
            $dob,
            $gender,
            $occupation_type,
            $occupation_content,
            $address,
            $status,
            $created_at,
            $updated_at
        ];

        // Execute the statement
        if ($stmt->execute($params)) {
            echo json_encode(['success' => true, 'message' => 'KYC details inserted successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to insert KYC details.']);
        }

        // Close the statement
       
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid input. Please provide all required fields.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}


?>