<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Make sure $pdo is defined in this file
require_once 'castHelper.php'; 
try {
    // Connect to DB
   
    // Query with JOIN
    $stmt = $pdo->query("
        SELECT 
            leaderboard.lb_id AS leaderboard_id,
            leaderboard.points,
            leaderboard.user_id,
            users.user_id AS user_id,
            users.name,
            users.userName
            users.profile_url
        FROM leaderboard
        JOIN users ON leaderboard.user_id = users.user_id
        ORDER BY leaderboard.points ASC
    ");

    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
  $results = array_map('castTypes', $results);
    // Respond with JSON
    echo json_encode([
        'status' => 'success',
        'data' => $results
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
