<?php
// header("Access-Control-Allow-Origin: *");
// header("Content-Type: application/json; charset=UTF-8");
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // $pdo connection
require_once 'castHelper.php'; 
if (!isset($_GET['course_id']) || empty(trim($_GET['course_id']))) {
    http_response_code(400);
    echo json_encode(["error" => "Missing or invalid course_id"]);
    exit();
}

$course_id = trim($_GET['course_id']);

try {
    // 1. Fetch lessons for given course_id
    $stmt = $pdo->prepare("SELECT * FROM lessions WHERE course_id = :course_id");
    $stmt->bindParam(':course_id', $course_id, PDO::PARAM_STR);
    $stmt->execute();
    $lessons = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 2. For each lesson, fetch related file URLs
    foreach ($lessons as &$lesson) {
        $lesson_id = $lesson['lession_id'];

        $fileStmt = $pdo->prepare("SELECT * FROM courses_file_url WHERE lession_id = :lesson_id");
        $fileStmt->bindParam(':lesson_id', $lesson_id, PDO::PARAM_STR);
        $fileStmt->execute();
        $files = $fileStmt->fetchAll(PDO::FETCH_ASSOC);

        $lesson['files'] = $files;  // add file URLs inside lesson array
    }
    $lessons = array_map('castTypes', $lessons);
      echo json_encode([
        "status" => 'success',
        "data" => $lessons
    ]);


} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>
