<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST Allowed."]);
    exit;
}

require_once 'db.php';
require_once 'function.php'; // Include Function

// Check required fields
if (
    empty($_POST['email_or_phone']) ||
    empty($_POST['password']) ||
    empty($_POST['device_name'])
) {
    echo json_encode(["error" => "All fields are required."]);
    exit;
}

$input = htmlspecialchars($_POST['email_or_phone']);
$password = $_POST['password']; // ✅ DO NOT hash here
$device_name = htmlspecialchars($_POST['device_name']);
$now = date('Y-m-d H:i:s');

// Check if it's email or phone
if (filter_var($input, FILTER_VALIDATE_EMAIL)) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
} else {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE phone = ?");
}

$stmt->execute([$input]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo json_encode(["error" => "Invalid email/phone or password."]);
    exit;
}

$hasPassword =$user['password'];
// ✅ Correct usage of password_verify
if (!password_verify($password, $hasPassword)) {
    echo json_encode(["error" => "Invalid password."]);
    exit;
}

// Generate token
$user_token_id = generateUserTokenId($pdo);
$token = generateToken();
$token_expire = date('Y-m-d H:i:s', strtotime('+30 days'));

$tokenSql = "INSERT INTO user_token (user_token_id, user_id, token, device_name, token_expire, status, updated_at)
             VALUES (?, ?, ?, ?, ?, ?, ?)";
$tokenStmt = $pdo->prepare($tokenSql);
if ($tokenStmt->execute([
    $user_token_id,
    $user['user_id'],
    $token,
    $device_name,
    $token_expire,
    '1',
    $now
])) {
    
    // Fetch data from `user_kyc` table where user_id matches
$user_id = $user['user_id'];
    // Fetch username from `users` table
$sql1 = "SELECT userName,profile_url FROM `users` WHERE `user_id` = :user_id";
$stmt1 = $pdo->prepare($sql1);
$stmt1->bindParam(':user_id', $user_id);
$stmt1->execute();
$user_data = $stmt1->fetch(PDO::FETCH_ASSOC) ?: null;

// Fetch KYC data from `user_kyc` table
$sql2 = "SELECT * FROM `user_kyc` WHERE `user_id` = :user_id";
$stmt2 = $pdo->prepare($sql2);
$stmt2->bindParam(':user_id', $user_id);
$stmt2->execute();
$kyc_data = $stmt2->fetch(PDO::FETCH_ASSOC) ?: null;

// Fetch account settings from `user_account_setting` table
$sql3 = "SELECT * FROM `user_account_setting` WHERE `user_id` = :user_id";
$stmt3 = $pdo->prepare($sql3);
$stmt3->bindParam(':user_id', $user_id);
$stmt3->execute();
$account_settings = $stmt3->fetch(PDO::FETCH_ASSOC) ?: null;

echo json_encode([
    "status" => "success",
    "message" => "Login successful.",
    "user_id" => $user['user_id'],
    "token" => $token,
    "expires_at" => $token_expire,
    "user_data" => $user_data,
    "data" => $kyc_data,
    "account_settings" => $account_settings
]);

} else {
    echo json_encode(["error" => "Login failed. Could not create token."]);
}
?>
