<?php

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => false, "message" => "Only POST requests are allowed."]);
    exit;
}

require_once 'db.php';
require_once 'function.php';

// Get POST data
$user_id = $_POST['user_id'] ?? null;
$feed_id = $_POST['feed_id'] ?? null;
$contents = $_POST['contents'] ?? null;
$commentStatus = $_POST['commentStatus'] ?? null;
$education_type = $_POST['education_type'] ?? null;
$feed_privacy = $_POST['feed_privacy'] ?? null;

if (!$feed_id) {
    echo json_encode(["status" => "error", "message" => "Missing feed_id"]);
    exit;
}

// Prepare the query
$fields = [];
$params = [];
$types = "";

// Add optional fields
if (!is_null($contents)) {
    $fields[] = "contents = ?";
    $params[] = $contents;
    $types .= "s";
}
if (!is_null($commentStatus)) {
    $fields[] = "commentStatus = ?";
    $params[] = $commentStatus;
    $types .= "s";
}
if (!is_null($education_type)) {
    $fields[] = "education_type = ?";
    $params[] = $education_type;
    $types .= "s";
}
if (!is_null($feed_privacy)) {
    $fields[] = "feed_privacy = ?";
    $params[] = $feed_privacy;
    $types .= "s";
}

// Always update updated_at
$fields[] = "updated_at = NOW()";

if (empty($fields)) {
    echo json_encode(["status" => "error", "message" => "No fields to update"]);
    exit;
}
$sql = "UPDATE feeds SET " . implode(", ", $fields) . " WHERE feed_id = ? ";
$params[] = $feed_id;

$stmt = $pdo->prepare($sql);

if ($stmt->execute($params)) {
    echo json_encode(["status" => "success", "message" => "Updated Successful"]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Update failed",
        "error" => $stmt->errorInfo()
    ]);
}

?>
