<?php
// Database connection
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include DB connection

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve POST data
    $option_id = substr(uniqid(), 0, 8) ?? null;
    $quiz_id = $_POST['quiz_id'] ?? null;
    $option = $_POST['option'] ?? null;
    $status = $_POST['status'] ?? null;
    $created_at = date('Y-m-d H:i:s');
    $updated_at = date('Y-m-d H:i:s');

    // Validate required fields
    if ($quiz_id && $option && $status) {
        // Prepare the SQL statement
        $stmt = $pdo->prepare("INSERT INTO `options`(`id`, `option_id`, `quiz_id`, `option`, `status`, `created_at`, `updated_at`) VALUES (NULL, ?, ?, ?, ?, ?, ?)");
        $stmt->bindValue(1, $option_id, PDO::PARAM_STR);
        $stmt->bindValue(2, $quiz_id, PDO::PARAM_STR);
        $stmt->bindValue(3, $option, PDO::PARAM_STR);
        $stmt->bindValue(4, $status, PDO::PARAM_STR);
        $stmt->bindValue(5, $created_at, PDO::PARAM_STR);
        $stmt->bindValue(6, $updated_at, PDO::PARAM_STR);

        // Execute the query
        if ($stmt->execute()) {
            echo json_encode(["success" => true, "message" => "Option inserted successfully."]);
        } else {
            echo json_encode(["success" => false, "message" => "Error inserting option: " . $stmt->error]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "All fields are required."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
}
?>
