<?php
// Database connection
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include DB connection
require_once 'function.php'; // Include Function

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve POST data
    $quiz_id = substr(uniqid(), 0, 8) ?? null;
    $category_id = $_POST['category_id'] ?? null;
    $title = $_POST['title'] ?? null;
    $contents = $_POST['contents'] ?? null;
    $answer = $_POST['answer'] ?? null;
    $status = $_POST['status'] ?? null;
    $options = $_POST['options'] ?? []; // Expecting an array of options
    $created_at = date('Y-m-d H:i:s');
    $updated_at = date('Y-m-d H:i:s');

    // Validate required fields
    if ($category_id && $title && $contents && $answer && $status && !empty($options)) {
        try {
            // Begin transaction
            $pdo->beginTransaction();

            // Insert quiz
            $stmt = $pdo->prepare("INSERT INTO `quizs`(`quiz_id`, `category_id`, `title`, `contents`, `answer`, `status`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bindValue(1, $quiz_id, PDO::PARAM_STR);
            $stmt->bindValue(2, $category_id, PDO::PARAM_STR);
            $stmt->bindValue(3, $title, PDO::PARAM_STR);
            $stmt->bindValue(4, $contents, PDO::PARAM_STR);
            $stmt->bindValue(5, $answer, PDO::PARAM_STR);
            $stmt->bindValue(6, $status, PDO::PARAM_STR);
            $stmt->bindValue(7, $created_at, PDO::PARAM_STR);
            $stmt->bindValue(8, $updated_at, PDO::PARAM_STR);

            if (!$stmt->execute()) {
                throw new Exception("Error inserting quiz.");
            }
            // Insert options
            $optionStmt = $pdo->prepare("INSERT INTO `options`(`id`, `option_id`, `quiz_id`, `option`, `status`, `created_at`, `updated_at`) VALUES (NULL, ?, ?, ?, ?, ?, ?)");
            foreach ($options as $option) {
                $option_id = substr(uniqid(), 0, 8);
                $optionStmt->bindValue(1, $option_id, PDO::PARAM_STR);
                $optionStmt->bindValue(2, $quiz_id, PDO::PARAM_STR);
                $optionStmt->bindValue(3, $option, PDO::PARAM_STR);
                $optionStmt->bindValue(4, $status, PDO::PARAM_STR);
                $optionStmt->bindValue(5, $created_at, PDO::PARAM_STR);
                $optionStmt->bindValue(6, $updated_at, PDO::PARAM_STR);

                if (!$optionStmt->execute()) {
                    throw new Exception("Error inserting option.");
                }
            }

            // Commit transaction
            $pdo->commit();
            echo json_encode(["success" => true, "message" => "Quiz and options inserted successfully."]);
        } catch (Exception $e) {
            // Rollback transaction on error
            $pdo->rollBack();
            echo json_encode(["success" => false, "message" => $e->getMessage()]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "All fields are required, including options."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
}
?>