<?php

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => false, "message" => "Only POST requests are allowed."]);
    exit;
}

require_once 'db.php';
require_once 'function.php';

// Get POST data
$user_id = $_POST['user_id'] ?? null;
$reels_id = $_POST['reels_id'] ?? null;
$captioon = $_POST['captioon'] ?? null;
$comment_allow = $_POST['comment_allow'] ?? null;
$education_type = $_POST['education_type'] ?? null;
$video_privacy = $_POST['video_privacy'] ?? null;

if (!$reels_id) {
    echo json_encode(["status" => "error", "message" => "Missing reels_id"]);
    exit;
}

// Prepare the query
$fields = [];
$params = [];
$types = "";

// Add optional fields
if (!is_null($captioon)) {
    $fields[] = "captioon = ?";
    $params[] = $captioon;
    $types .= "s";
}
if (!is_null($comment_allow)) {
    $fields[] = "comment_allow = ?";
    $params[] = $comment_allow;
    $types .= "s";
}
if (!is_null($education_type)) {
    $fields[] = "education_type = ?";
    $params[] = $education_type;
    $types .= "s";
}
if (!is_null($video_privacy)) {
    $fields[] = "video_privacy = ?";
    $params[] = $video_privacy;
    $types .= "s";
}

// Always update updated_at
$fields[] = "updated_at = NOW()";

if (empty($fields)) {
    echo json_encode(["status" => "error", "message" => "No fields to update"]);
    exit;
}
$sql = "UPDATE reels SET " . implode(", ", $fields) . " WHERE reels_id = ? ";
$params[] = $reels_id;

$stmt = $pdo->prepare($sql);

if ($stmt->execute($params)) {
    echo json_encode(["status" => "success", "message" => "Updated Successful"]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Update failed",
        "error" => $stmt->errorInfo()
    ]);
}


?>
