<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method. Only POST is allowed."]);
    exit;
}

require_once 'db.php';
require_once 'function.php';

// Validate required fields
$required = ['name', 'phone', 'password', 'device_name'];
foreach ($required as $field) {
    if (empty($_POST[$field])) {
        echo json_encode(["error" => "All fields are required."]);
        exit;
    }
}

// Prepare user data
$user_id = uniqid('USR_');
$name = htmlspecialchars($_POST['name']);
$userName = htmlspecialchars($_POST['userName']);
$email = 'none';
$phone = htmlspecialchars($_POST['phone']);
$oppucation_type = htmlspecialchars($_POST['oppucation_type']);
$oppucation_content = htmlspecialchars($_POST['oppucation_content']);
$gender = isset($_POST['gender']) ? htmlspecialchars($_POST['gender']) : '';
$password = $_POST['password'];
$device_name = htmlspecialchars($_POST['device_name']);
$status = '1';
$now = date('Y-m-d H:i:s');

// // Check if email exists
// $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
// $stmt->execute([$email]);
// if ($stmt->rowCount() > 0) {
//     echo json_encode(["error" => "Email already registered."]);
//     exit;
// }

$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

try {

       // Handle file upload
    $fileType = '';
    $file_url = '';
    if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = __DIR__ . '/userprofile/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $fileTmpPath = $_FILES['file']['tmp_name'];
        $fileName = basename($_FILES['file']['name']);
        $fileType = pathinfo($fileName, PATHINFO_EXTENSION);
        $newFileName = uniqid('doc_', true) . '.' . $fileType;
        $destPath = $uploadDir . $newFileName;

        if (move_uploaded_file($fileTmpPath, $destPath)) {
            $file_url = 'userprofile/' . $newFileName;
        } else {
            throw new Exception("File upload failed.");
        }
    }

    // Insert user
    $sql = "INSERT INTO users (user_id, name, userName, email, phone, password, status, profile_url,created_at, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    if (!$stmt->execute([$user_id, $name, $userName, $email, $phone, $hashedPassword, $status, $file_url,$now, $now])) {
        throw new Exception("User insert failed.");
    }

    // Insert token
    $user_token_id = generateUserTokenId($pdo);
    $token = generateToken();
    $token_expire = date('Y-m-d H:i:s', strtotime('+30 days'));
    $tokenSql = "INSERT INTO user_token (user_token_id, user_id, token, device_name, token_expire, status, updated_at)
                 VALUES (?, ?, ?, ?, ?, ?, ?)";
    $tokenStmt = $pdo->prepare($tokenSql);
    if (!$tokenStmt->execute([$user_token_id, $user_id, $token, $device_name, $token_expire, '1', $now])) {
        throw new Exception("Token insert failed.");
    }

    // Insert KYC
    $kyc_id = generateKycId($pdo);
    $kycSql = "INSERT INTO user_kyc (user_id, kyc_id, name, bio, dob, gender, oppucation_type, oppucation_content, address, status, created_at, updated_at)
               VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $kycStmt = $pdo->prepare($kycSql);
    $kycInserted = $kycStmt->execute([
        $user_id,
        $kyc_id,
        $name,
        'This is a sample bio.',
        '0000-00-00',
        $gender,
        $oppucation_type,
        $oppucation_content,
        '',
        '1',
        $now,
        $now
    ]);
    if (!$kycInserted) {
        throw new Exception("KYC insert failed.");
    }

 

    // Insert account setting
    $uas_id = generateusaiId($pdo);
    $uasSql = "INSERT INTO user_account_setting (user_id, uas_id, profile_visibility, comment_show, who_follow_you, updated_at)
               VALUES (?, ?, ?, ?, ?, ?)";
    $uasStmt = $pdo->prepare($uasSql);
    if (!$uasStmt->execute([
        $user_id,
        $uas_id,
        'public',
        'public',
        'Everyone',
        $now
    ])) {
        throw new Exception("Account setting insert failed.");
    }


    // Fetch username from `users` table
$sql1 = "SELECT userName,profile_url FROM `users` WHERE `user_id` = :user_id";
$stmt1 = $pdo->prepare($sql1);
$stmt1->bindParam(':user_id', $user_id);
$stmt1->execute();
$user_data = $stmt1->fetch(PDO::FETCH_ASSOC) ?: null;

// Fetch KYC data from `user_kyc` table
$sql2 = "SELECT * FROM `user_kyc` WHERE `user_id` = :user_id";
$stmt2 = $pdo->prepare($sql2);
$stmt2->bindParam(':user_id', $user_id);
$stmt2->execute();
$kyc_data = $stmt2->fetch(PDO::FETCH_ASSOC) ?: null;

// Fetch account settings from `user_account_setting` table
$sql3 = "SELECT * FROM `user_account_setting` WHERE `user_id` = :user_id";
$stmt3 = $pdo->prepare($sql3);
$stmt3->bindParam(':user_id', $user_id);
$stmt3->execute();
$account_settings = $stmt3->fetch(PDO::FETCH_ASSOC) ?: null;

// Return response
echo json_encode([
    "success" => true,
    "message" => "User registered successfully.",
    "user_id" => $user_id,
    "userName" => $user_data['userName'] ?? $userName, // Fallback if not found
    "token" => $token,
    "expires_at" => $token_expire,
    "file_url" => $file_url,
    "user_data" => $user_data,
    "data" => $kyc_data,
    "account_settings" => $account_settings
]);

} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
}
?>
