<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'castHelper.php'; 
try {
    $pdo = new PDO('mysql:host=localhost;dbname=your_db', 'username', 'password');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $type = isset($_GET['type']) ? $_GET['type'] : null;
    $q = isset($_GET['q']) ? trim($_GET['q']) : '';

    $response = [];

    if ($type === 'user' && $q !== '') {
        // Step 1: Find matching users
        $stmt = $pdo->prepare("SELECT * FROM users WHERE name LIKE :q OR email LIKE :q LIMIT 10");
        $stmt->execute(['q' => "%$q%"]);
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($users) {
            foreach ($users as &$user) {
                $user_id = $user['id'];

                // Step 2a: Get Reels
                $stmtReels = $pdo->prepare("SELECT id, title, description FROM reels WHERE user_id = :uid");
                $stmtReels->execute(['uid' => $user_id]);
                $user['reels'] = $stmtReels->fetchAll(PDO::FETCH_ASSOC);

                // Step 2b: Get Notes
                $stmtNotes = $pdo->prepare("SELECT id, title, content FROM notes WHERE user_id = :uid");
                $stmtNotes->execute(['uid' => $user_id]);
                $user['notes'] = $stmtNotes->fetchAll(PDO::FETCH_ASSOC);

                // Step 2c: Get Courses (if user is instructor)
                $stmtCourses = $pdo->prepare("SELECT id, title, description FROM courses WHERE instructor_id = :uid");
                $stmtCourses->execute(['uid' => $user_id]);
                $user['courses'] = $stmtCourses->fetchAll(PDO::FETCH_ASSOC);

                // Step 3: Related users
                $stmtRelated = $pdo->prepare("SELECT id, name, email FROM users WHERE id != :uid AND name LIKE :name LIMIT 5");
                $stmtRelated->execute([
                    'uid' => $user_id,
                    'name' => '%' . explode(' ', $user['name'])[0] . '%'
                ]);
                $user['related_users'] = $stmtRelated->fetchAll(PDO::FETCH_ASSOC);
            }

            $response = [
                'status' => 'success',
                'data' => $users
            ];
        } else {
            $response = [
                'status' => 'not_found',
                'message' => "No users found for query '$q'"
            ];
        }

    } else {
        $response = [
            'status' => 'error',
            'message' => 'Missing or invalid type and query parameters.'
        ];
    }

} catch (PDOException $e) {
    http_response_code(500);
    $response = [
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ];
}

echo json_encode($response);
