  <div class="dashboard-content">
      <div class="card" style="grid-column: span 2;">
          <h2>LeaderBoard List</h2>
           <?php
                $limit = 10;
                $nextcount = isset($_GET['nextcount']) && is_numeric($_GET['nextcount']) ? (int) $_GET['nextcount'] : 1;
                $offset = ($nextcount - 1) * $limit;

                // Fetch paginated semesters
                $semesters = getDataFromDatabasePaging('leaderboard', '*', '', [], $limit, $offset);

                // Get total number of records to calculate total nextcounts
                $totalResult = getDataFromDatabase('leaderboard', 'COUNT(*) as total');
                $totalRows = $totalResult[0]['total'];
                $totalnextcounts = ceil($totalRows / $limit);
            ?>

          <table>
              <thead>
                  <tr>
                      <th>#</th>
                      <th>Title</th>
                      <th>Type</th>
                      <th>Price</th>
                      <th>Status</th>
                      <th>Action</th>
                  </tr>
              </thead>
              <tbody>
                  <?php foreach ($semesters as $index => $semester): ?>
                  <tr>
                      <td><?= $offset + $index + 1 ?></td>
                      <td><?= htmlspecialchars($semester['title']) ?></td>
                      <td><?= htmlspecialchars($semester['type']) ?></td>
                      <td><?= htmlspecialchars($semester['price']) ?></td>
                      <td><?= $semester['status'] ? 'Active' : 'Inactive' ?></td>
                      <td>
                          <a href="dashboard.php?page=NoteDetail&nid=<?= $semester['course_id'] ?>" class="edit-btn">View</a>
                          <a href="#" class="delete-btn">Delete</a>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              </tbody>
          </table>

          <!-- Pagination Controls -->
          <div class="pagination">
              <?php if ($nextcount > 1): ?>
              <a href="dashboard.php?page=semester&nextcount=<?= $nextcount - 1 ?>">&laquo; Prev</a>
              <?php endif; ?>

              <?php for ($i = 1; $i <= $totalnextcounts; $i++): ?>
              <a href="dashboard.php?page=semester&nextcount=<?= $i ?>"
                  <?= $i == $nextcount ? 'style="font-weight:bold;"' : '' ?>><?= $i ?></a>
              <?php endfor; ?>

              <?php if ($nextcount < $totalnextcounts): ?>
              <a href="dashboard.php?page=semester&nextcount=<?= $nextcount + 1 ?>">Next &raquo;</a>
              <?php endif; ?>
          </div>

          <style>
          .pagination {
              margin-top: 15px;
          }

          .pagination a {
              display: inline-block;
              padding: 6px 12px;
              margin: 0 3px;
              border: 1px solid #ccc;
              text-decoration: none;
              color: #333;
          }

          .pagination a:hover {
              background-color: #6c63ff;
          }
          </style>

      </div>

      
  </div>