  <div class="dashboard-content">
      <div class="card" style="grid-column: span 2;">
          <div class="row_">
              <h2>Users List</h2>
              <a href="#" class="add-btn"
                  onclick="document.getElementById('addFacultyPopup').style.display='block'; return false;">Users</a>

              <!-- Popup Modal -->
              <div id="addFacultyPopup" class="popup-modal" style="display:none;">
                  <div class="popup-content">
                      <h3>Add Semester</h3>
                      <form id="addSemesterForm" method="post">

                          <select id="status" name="faculty_id" required>
                              <?php
                // Example static data. Replace with DB fetch in production.
                            $facultys = getDataFromDatabase('faculty', '*', '', [],);
                            foreach ($facultys as $index => $faculty) {
                                echo "<option value='{$faculty['fac_id']}'>{$faculty['title']}</option>";
                            }
                            ?>

                          </select>
                          <label for="facultyName">Semester Titel:</label>
                          <input type="text" id="facultyName" name="title" value="Semester" required>
                          <label for="facultyName">Number of Semester</label>
                          <input type="number" class="input_field" id="facultyName" name="number" value="8" required>
                          <label for="status">Status</label>
                          <select id="status" name="status" required>
                              <option value="1">Active </option>
                              <option value="0">DeActive</option>

                          </select>

                          <br><br>
                          <button type="submit" class="submit-btn">Submit</button>
                          <button type="button" class="add-btn"
                              onclick="document.getElementById('addFacultyPopup').style.display='none';">Cancel</button>
                      </form>
                  </div>
              </div>
          </div>
          <?php
                $limit = 10;
                $nextcount = isset($_GET['nextcount']) && is_numeric($_GET['nextcount']) ? (int) $_GET['nextcount'] : 1;
                $offset = ($nextcount - 1) * $limit;

                // Fetch paginated semesters
                $users = getDataFromDatabasePaging('users', '*', '', [], $limit, $offset);

                // Get total number of records to calculate total nextcounts
                $totalResult = getDataFromDatabase('users', 'COUNT(*) as total');
                $totalRows = $totalResult[0]['total'];
                $totalnextcounts = ceil($totalRows / $limit);
            ?>

          <table>
              <thead>
                  <tr>
                      <th>#</th>
                      <th>User ID</th>
                      <th>Name</th>
                      <th>UserName</th>
                      <th>Status</th>
                      <th>Created</th>
                      <th>Action</th>
                  </tr>
              </thead>
              <tbody>
                  <?php foreach ($users as $index => $user): ?>
                  <tr>
                      <td><?= $offset + $index + 1 ?></td>
                      <td><?= htmlspecialchars($user['user_id']) ?></td>
                      <td><?= htmlspecialchars($user['name']) ?></td>
                      <td><?= htmlspecialchars($user['userName']) ?></td>
                      <td><?= $user['status'] ? 'Active' : 'Inactive' ?></td>
                       <td><?= htmlspecialchars($user['created_at']) ?></td>
                      <td>
                        <a href="dashboard.php?page=userDetail&uid=<?= $user['user_id'] ?>" class="add-btn">View</a>
                          <a href="#" class="delete-btn">Delete</a>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              </tbody>
          </table>

          <!-- Pagination Controls -->
          <div class="pagination">
              <?php if ($nextcount > 1): ?>
              <a href="dashboard.php?page=users&nextcount=<?= $nextcount - 1 ?>">&laquo; Prev</a>
              <?php endif; ?>

              <?php for ($i = 1; $i <= $totalnextcounts; $i++): ?>
              <a href="dashboard.php?page=users&nextcount=<?= $i ?>"
                  <?= $i == $nextcount ? 'style="font-weight:bold;"' : '' ?>><?= $i ?></a>
              <?php endfor; ?>

              <?php if ($nextcount < $totalnextcounts): ?>
              <a href="dashboard.php?page=users&nextcount=<?= $nextcount + 1 ?>">Next &raquo;</a>
              <?php endif; ?>
          </div>

          <style>
          .pagination {
              margin-top: 15px;
          }

          .pagination a {
              display: inline-block;
              padding: 6px 12px;
              margin: 0 3px;
              border: 1px solid #ccc;
              text-decoration: none;
              color: #333;
          }

          .pagination a:hover {
              background-color: #6c63ff;
          }
          </style>

      </div>
  </div>



  <div id="facultySuccessToast">Faculty added successfully!</div>


  <script>
$(document).ready(function() {
    // Function to load faculty data

    // Attach toggle status handler
    $('.statusToggle').on('change', function() {
        var facultyId = $(this).data('id');
        var newStatus = $(this).is(':checked') ? 1 : 0;

        $.ajax({
            url: '/Sikshashare/update_faculty_status.php',
            type: 'POST',
            data: {
                id: facultyId,
                status: newStatus
            },
            success: function(response) {
                console.log('Status updated for faculty ID:', facultyId);
            },
            error: function() {
                alert('Failed to update status.');
            }
        });
    });

    // Submit form handler
    $('#addSemesterForm').on('submit', function(e) {
        e.preventDefault();

        if ($('#facultyProgressBar').length === 0) {
            $(this).append(
                '<div id="facultyProgressBar" style="margin-top:10px;"><progress style="width:100%;"></progress></div>'
            );
        }

        $('#facultyProgressBar').show();

        $.ajax({
            url: '/Sikshashare/semester_post.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(res) {
                if (res.status === 'success') {
                    // Show toast
                    var toast = $('#facultySuccessToast');
                    toast.addClass('show');
                    setTimeout(function() {
                        toast.removeClass('show');
                    }, 3000);

                    $('#addFacultyPopup').hide();
                    $('#facultyProgressBar').hide();

                    // 🔁 Reload table
                    loadFacultyTable();

                    // Optional: reset the form
                    $('#addFacultyForm')[0].reset();
                } else {
                    alert(res.message || 'Error adding faculty.');
                    $('#facultyProgressBar').hide();
                }
            },
            error: function(xhr) {
                alert('Error adding faculty.');
                $('#facultyProgressBar').hide();
            }
        });
    });
});
  </script>