  <div class="dashboard-content">
      <div class="card" style="grid-column: span 2;">
         <div class="row_">
              <h2>Banner List</h2>
              <a href="dashboard.php?page=createBanner" class="add-btn"
                 >Create</a>
          </div>
          <?php
                $limit = 10;
                $nextcount = isset($_GET['nextcount']) && is_numeric($_GET['nextcount']) ? (int) $_GET['nextcount'] : 1;
                $offset = ($nextcount - 1) * $limit;
                // Fetch paginated semesters
                $slider = getDataFromDatabasePaging('adv_sliders', '*', '', [], $limit, $offset);
                // Get total number of records to calculate total nextcounts
                $totalResult = getDataFromDatabase('adv_sliders', 'COUNT(*) as total');
                $totalRows = $totalResult[0]['total'];
                $totalnextcounts = ceil($totalRows / $limit);
            ?>
          <table>
              <thead>
                  <tr>
                      <th>#</th>
                      <th>Slider ID</th>
                      <th>Position Screen</th>
                      <th>Status</th>
                      <th>Created</th>
                      <th>Action</th>
                  </tr>
              </thead>
              <tbody>
                  <?php foreach ($slider as $index => $sliderdata): ?>
                  <tr>
                      <td><?= $offset + $index + 1 ?></td>
                      <td><?= htmlspecialchars($sliderdata['slider_id']) ?></td>
                      <td><?= htmlspecialchars($sliderdata['position_screen']) ?></td>
                      <td><?= $sliderdata['status'] ?></td>
                       <td><?= htmlspecialchars($sliderdata['created_at']) ?></td>
                      <td>
                          <a href="dashboard.php?page=sliderDetail&Slid=<?= $sliderdata['slider_id'] ?>" class="add-btn">View</a>
                          <a href="#" class="delete-btn ml-3">Delete</a>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              </tbody>
          </table>

          <!-- Pagination Controls -->
          <div class="pagination">
              <?php if ($nextcount > 1): ?>
              <a href="dashboard.php?page=banner&nextcount=<?= $nextcount - 1 ?>">&laquo; Prev</a>
              <?php endif; ?>

              <?php for ($i = 1; $i <= $totalnextcounts; $i++): ?>
              <a href="dashboard.php?page=banner&nextcount=<?= $i ?>"
                  <?= $i == $nextcount ? 'style="font-weight:bold;"' : '' ?>><?= $i ?></a>
              <?php endfor; ?>

              <?php if ($nextcount < $totalnextcounts): ?>
              <a href="dashboard.php?page=banner&nextcount=<?= $nextcount + 1 ?>">Next &raquo;</a>
              <?php endif; ?>
          </div>

          <style>
          .pagination {
              margin-top: 15px;
          }
          .pagination a {
              display: inline-block;
              padding: 6px 12px;
              margin: 0 3px;
              border: 1px solid #ccc;
              text-decoration: none;
              color: #333;
          }
          .pagination a:hover {
              background-color: #6c63ff;
          }
          </style>

      </div>
  </div>

  