  <div class="dashboard-content">
      <div class="card" style="grid-column: span 2;">
          <div class="row_">
              <h2>Quiz Category</h2>

              <a href="dashboard.php?page=categoryCreate" class="add-btn">Create New Category</a>
          </div>
          <?php
                $limit = 10;
                $nextcount = isset($_GET['nextcount']) && is_numeric($_GET['nextcount']) ? (int) $_GET['nextcount'] : 1;
                $offset = ($nextcount - 1) * $limit;
 
                // Fetch paginated semesters
                $semesters = getDataFromDatabasePaging('quiz_category', '*', '', [], $limit, $offset);

                // Get total number of records to calculate total nextcounts
                $totalResult = getDataFromDatabase('quiz_category', 'COUNT(*) as total');
                $totalRows = $totalResult[0]['total'];
                $totalnextcounts = ceil($totalRows / $limit);
            ?>
          <table>
              <thead>
                  <tr>
                      <th>#</th>
                      <th>Quiz CatID</th>
                      <th>Name</th>
                      <th>Home Screen Title</th>
                      <th>Screen Status</th>
                      <th>Status</th>
                      <th>Created</th>
                      <th>Action</th>
                  </tr>
              </thead>
              <tbody>
                  <?php foreach ($semesters as $index => $semester): ?>
                  <tr>
                      <td><?= $offset + $index + 1 ?></td>
                      <td><?= htmlspecialchars($semester['category_id']) ?></td>
                      <td><?= htmlspecialchars($semester['name']) ?></td>
                      <td><?= htmlspecialchars($semester['home_title']) ?></td>
                      <td><?= htmlspecialchars($semester['home_status']) ?></td>
                      <td><?= $semester['status'] ? 'Active' : 'Inactive' ?></td>
                      <td><?= htmlspecialchars($semester['update_at']) ?></td>
                      <td>
                          <a href="#" class="edit-btn">Edit</a>
                          <a href="#" class="delete-btn">Delete</a>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              </tbody>
          </table>

          <!-- Pagination Controls -->
          <div class="pagination">
              <?php if ($nextcount > 1): ?>
              <a href="dashboard.php?page=quiz&nextcount=<?= $nextcount - 1 ?>">&laquo; Prev</a>
              <?php endif; ?>

              <?php for ($i = 1; $i <= $totalnextcounts; $i++): ?>
              <a href="dashboard.php?page=quiz&nextcount=<?= $i ?>"
                  <?= $i == $nextcount ? 'style="font-weight:bold;"' : '' ?>><?= $i ?></a>
              <?php endfor; ?>

              <?php if ($nextcount < $totalnextcounts): ?>
              <a href="dashboard.php?page=quiz&nextcount=<?= $nextcount + 1 ?>">Next &raquo;</a>
              <?php endif; ?>
          </div>

          <style>
          .pagination {
              margin-top: 15px;
          }

          .pagination a {
              display: inline-block;
              padding: 6px 12px;
              margin: 0 3px;
              border: 1px solid #ccc;
              text-decoration: none;
              color: #333;
          }

          .pagination a:hover {
              background-color: #6c63ff;
          }
          </style>

      </div>
  </div>



  <div id="facultySuccessToast">Faculty added successfully!</div>


  <script>
$(document).ready(function() {
    // Function to load faculty data

    // Attach toggle status handler
    $('.statusToggle').on('change', function() {
        var facultyId = $(this).data('id');
        var newStatus = $(this).is(':checked') ? 1 : 0;

        $.ajax({
            url: '/Sikshashare/update_faculty_status.php',
            type: 'POST',
            data: {
                id: facultyId,
                status: newStatus
            },
            success: function(response) {
                console.log('Status updated for faculty ID:', facultyId);
            },
            error: function() {
                alert('Failed to update status.');
            }
        });
    });

    // Submit form handler
    $('#addSemesterForm').on('submit', function(e) {
        e.preventDefault();

        if ($('#facultyProgressBar').length === 0) {
            $(this).append(
                '<div id="facultyProgressBar" style="margin-top:10px;"><progress style="width:100%;"></progress></div>'
            );
        }

        $('#facultyProgressBar').show();

        $.ajax({
            url: '/Sikshashare/semester_post.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(res) {
                if (res.status === 'success') {
                    // Show toast
                    var toast = $('#facultySuccessToast');
                    toast.addClass('show');
                    setTimeout(function() {
                        toast.removeClass('show');
                    }, 3000);

                    $('#addFacultyPopup').hide();
                    $('#facultyProgressBar').hide();

                    // 🔁 Reload table
                    loadFacultyTable();

                    // Optional: reset the form
                    $('#addFacultyForm')[0].reset();
                } else {
                    alert(res.message || 'Error adding faculty.');
                    $('#facultyProgressBar').hide();
                }
            },
            error: function(xhr) {
                alert('Error adding faculty.');
                $('#facultyProgressBar').hide();
            }
        });
    });
});
  </script>