
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Quiz List</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            margin: 0;
            font-family: 'Inter', Arial, sans-serif;
            background: #f7faff;
            color: #222;
        }
        .container {
            max-width: 900px;
            margin: 40px auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.06);
            padding: 32px 28px;
        }
        h2 {
            margin-top: 0;
            font-weight: 600;
            color: #6c63ff;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 24px;
        }
        th, td {
            padding: 12px 10px;
            border-bottom: 1px solid #e5e9f2;
            text-align: left;
            font-size: 1rem;
        }
        th {
            background: #f7fbff;
            color: #7b8bb2;
            font-weight: 600;
        }
        tr:last-child td {
            border-bottom: none;
        }
        .badge {
            display: inline-block;
            padding: 2px 10px;
            border-radius: 12px;
            font-size: 0.85rem;
            font-weight: 600;
            background: #e3e0ff;
            color: #6c63ff;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Quiz List</h2>
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Quiz Title</th>
                    <th>Description</th>
                    <th>Category</th>
                    <th>Options</th>
                    <th>Answer</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Example static data. Replace with DB fetch in production.
                $quizzes = [
                    [
                        'title' => 'What is the capital of France?',
                        'description' => 'Choose the correct capital city.',
                        'category' => 'General',
                        'options' => ['Paris', 'London', 'Berlin', 'Madrid'],
                        'answer' => 'Paris'
                    ],
                    [
                        'title' => '2 + 2 = ?',
                        'description' => 'Simple math question.',
                        'category' => 'Math',
                        'options' => ['3', '4', '5', '6'],
                        'answer' => '4'
                    ],
                    [
                        'title' => 'Who invented the telephone?',
                        'description' => 'Identify the inventor.',
                        'category' => 'History',
                        'options' => ['Edison', 'Bell', 'Newton', 'Tesla'],
                        'answer' => 'Bell'
                    ]
                ];
                $i = 1;
                foreach ($quizzes as $quiz) {
                    echo "<tr>";
                    echo "<td>{$i}</td>";
                    echo "<td>{$quiz['title']}</td>";
                    echo "<td>{$quiz['description']}</td>";
                    echo "<td><span class='badge'>{$quiz['category']}</span></td>";
                    echo "<td>";
                    foreach ($quiz['options'] as $opt) {
                        echo htmlspecialchars($opt) . "<br>";
                    }
                    echo "</td>";
                    echo "<td><b>" . htmlspecialchars($quiz['answer']) . "</b></td>";
                    echo "</tr>";
                    $i++;
                }
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>