<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");

require_once 'db.php';      // Make sure this returns a valid PDO object named $pdo
require_once 'function.php';

if (!isset($_POST['user_id']) || !isset($_POST['bio'])) {
    echo json_encode(['status' => false, 'message' => 'Missing user_id or bio']);
    exit;
}

// Optional: sanitize input
$user_id = htmlspecialchars(strip_tags($_POST['user_id']));
$bio = htmlspecialchars(strip_tags($_POST['bio']));

try {
    $sql = "UPDATE user_kyc SET bio = :bio, updated_at = NOW() WHERE user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':bio', $bio);
    $stmt->bindParam(':user_id', $user_id);

    if ($stmt->execute()) {
        echo json_encode(["status" => 'success', "bio" => $bio, 'message' => 'Bio updated']);
    } else {
        echo json_encode(['status' => false, 'message' => 'Update failed']);
    }
} catch (PDOException $e) {
    echo json_encode(['status' => false, 'message' => 'DB Error: ' . $e->getMessage()]);
}
