<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php';
require_once 'function.php';
require_once 'castHelper.php'; 
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
    exit;
}

if (!isset($_GET['user_id'])) {
    http_response_code(400);
    echo json_encode(["error" => "Missing user_id parameter"]);
    exit;
}

$user_id = $_GET['user_id'];
$check_id = $_GET['check_id'] ?? null; // Optional: the ID to compare with (e.g. following_id)
$response = [];

try {
    $stmt = $pdo->prepare("SELECT userName,profile_url FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $response['users'] = $stmt->fetch(PDO::FETCH_ASSOC) ?: null;

    $stmt1 = $pdo->prepare("SELECT * FROM user_kyc WHERE user_id = ?");
    $stmt1->execute([$user_id]);
    $response['kyc'] = $stmt1->fetch(PDO::FETCH_ASSOC) ?: null;

    $stmt2 = $pdo->prepare("SELECT * FROM user_account_setting WHERE user_id = ?");
    $stmt2->execute([$user_id]);
    $response['account_setting'] = $stmt2->fetch(PDO::FETCH_ASSOC) ?: null;

    $stmt3 = $pdo->prepare("SELECT * FROM user_docupment WHERE user_id = ?");
    $stmt3->execute([$user_id]);
    $documents = $stmt3->fetchAll(PDO::FETCH_ASSOC);
    $response['documents'] = !empty($documents) ? $documents : null;

    // New is_following check
    if ($check_id !== null) {
        $stmt4 = $pdo->prepare("SELECT COUNT(*) FROM user_follows WHERE follower_id = ? AND following_id = ?");
        $stmt4->execute([$check_id,$user_id]);
        $isFollowing = $stmt4->fetchColumn() > 0;
        $response['is_following'] = $isFollowing;
    }

    echo json_encode(["status" => "success", "data" => $response]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
