<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
require_once 'db.php'; // Include PDO connection
require_once 'castHelper.php'; 
try {
    // Allow only GET method
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Only GET method is allowed"]);
        exit;
    }

    // Required user_id to filter feeds
    if (!isset($_GET['user_id'])) {
        echo json_encode(["status" => "error", "message" => "Missing or invalid user_id"]);
        exit;
    }

    $user_id =$_GET['user_id'];

    // Pagination
    $page = isset($_GET['page']) && $_GET['page'] > 0 ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) && $_GET['limit'] > 0 ? (int)$_GET['limit'] : 5;
    $offset = ($page - 1) * $limit;

    // Total feeds count for this user
    $count_sql = "SELECT COUNT(*) as total FROM reels WHERE user_id = :user_id";
    $count_stmt = $pdo->prepare($count_sql);
    $count_stmt->execute(['user_id' => $user_id]);
    $total = $count_stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Main query
       $sql = "SELECT f.*, u.name, u.userName, u.profile_url
        FROM reels f
        LEFT JOIN users u ON u.user_id = f.user_id
            WHERE f.user_id = :user_id
            ORDER BY f.id DESC
            LIMIT :limit OFFSET :offset";

    $stmt = $pdo->prepare($sql);
   $stmt->bindValue(':user_id', $user_id, PDO::PARAM_STR);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $data = [];

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $feed_id = $row['reels_id'];


            // Get comments
            $comments_stmt = $pdo->prepare("SELECT * FROM feed_comments WHERE feed_id = :feed_id");
            $comments_stmt->execute(['feed_id' => $feed_id]);
            $comments = $comments_stmt->fetchAll(PDO::FETCH_ASSOC);
            $row['total_comments'] = count($comments);

            // Get total likes
            $likes_stmt = $pdo->prepare("SELECT COUNT(*) FROM likes WHERE post_id = :feed_id");
            $likes_stmt->execute(['feed_id' => $feed_id]);
            $row['total_likes'] = (int)$likes_stmt->fetchColumn();

            // Note: is_liked not included in this version
            $row = array_map('castTypes', $row);
            $data[] = $row;
        }

        echo json_encode([
            "status" => "success",
            "data" => $data,
            "pagination" => [
                "page" => $page,
                "limit" => $limit,
                "totalData" => (int)$total,
                "pages" => ceil($total / $limit)
            ]
        ]);
    } else {
        echo json_encode(["status" => "success", "data" => [], "message" => "No feeds found for this user"]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "An error occurred", "error" => $e->getMessage()]);
}
?>
